/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.canvas.process;

import filenet.vw.api.VWAssociationDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWTextAnnotationDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWString;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.IVWSortItem;
import javax.swing.Icon;
import javax.swing.JMenuItem;

public class VWPropertyMenuItem
extends JMenuItem
implements IVWSortItem {
    protected Object m_dataObject = null;

    public VWPropertyMenuItem(Object dataObject, Icon icon) {
        super("temporary");
        this.m_dataObject = dataObject;
        this.setText(VWPropertyMenuItem.getDisplayName(dataObject));
        if (icon != null) {
            this.setIcon(icon);
        }
    }

    public Object getDataObject() {
        return this.m_dataObject;
    }

    public static String getDisplayName(Object dataObject) {
        if (dataObject == null) {
            return VWResource.s_blankName;
        }
        String name = null;
        if (dataObject instanceof VWMapNode) {
            VWMapNode mapNode = (VWMapNode)dataObject;
            name = mapNode.getName();
        } else if (dataObject instanceof VWRouteDefinition) {
            VWRouteDefinition routeDef = (VWRouteDefinition)dataObject;
            name = routeDef.getName();
        } else if (dataObject instanceof VWTextAnnotationDefinition) {
            VWTextAnnotationDefinition textAnnoDef = (VWTextAnnotationDefinition)dataObject;
            try {
                name = textAnnoDef.getName();
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
            }
        } else if (dataObject instanceof VWAssociationDefinition) {
            VWAssociationDefinition associationDef = (VWAssociationDefinition)dataObject;
            name = associationDef.getName();
        }
        if (name == null || name.length() == 0) {
            return VWPropertyMenuItem.getBlankName(dataObject);
        }
        return name;
    }

    public static String getBlankName(Object dataObject) {
        if (dataObject == null) {
            return VWResource.s_blankName;
        }
        int nId = -1;
        VWString defaultName = VWResource.s_blankLabel;
        if (dataObject instanceof VWMapNode) {
            VWMapNode mapNode = (VWMapNode)dataObject;
            nId = mapNode.getStepId();
            defaultName = VWResource.s_blankStepLabel;
        } else if (dataObject instanceof VWRouteDefinition) {
            VWRouteDefinition routeDef = (VWRouteDefinition)dataObject;
            nId = routeDef.getRouteId();
            defaultName = VWResource.s_blankRouteLabel;
        } else if (dataObject instanceof VWTextAnnotationDefinition) {
            VWTextAnnotationDefinition textAnnoDef = (VWTextAnnotationDefinition)dataObject;
            try {
                nId = textAnnoDef.getId();
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
            }
            defaultName = VWResource.s_blankTextAnnotationLabel;
        } else if (dataObject instanceof VWAssociationDefinition) {
            VWAssociationDefinition associationDef = (VWAssociationDefinition)dataObject;
            try {
                nId = associationDef.getId();
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
            }
            defaultName = VWResource.s_blankAssociationLabel;
        }
        if (nId != -1) {
            return defaultName.toString(Integer.toString(nId + 1));
        }
        return VWResource.s_blankName;
    }

    public String getName() {
        return this.getText();
    }
}

